﻿var _pizbNameSpace_I = 'PI.ZB.1200.ELearning.WebApplication.Instructor';
var _pizbNameSpace_S = 'PI.ZB.1200.ELearning.WebApplication.Student';

function str_trim(str) {
    str = str.replace(/^\s+/, '');
    for (var i = str.length - 1; i >= 0; i--) {
        if (/\S/.test(str.charAt(i))) {
            str = str.substring(0, i + 1);
            break;
        }
    }
    return str;
}

/* validate phone */
function checkPhone(str) {
    str = str_trim(str);
    var phone2 = /^(\+\d\d){0,1}\s{0,1}[0-9,\s]{5,}$/;
    if (str.match(phone2)) {
        return true;
    } else {
        return false;
    }
}
/* 
validuje pola tekstowe 
pole tekstowe musi mieć klasę 'req'
aby było wymagane
*/
function validateTextboxes(ErrorContainer) {
    var alltextBoxes = $(':text[id^=txt]');
    var emptyTextBoxes = $(':text[value=""][id^=txt][class^=req]');
    alltextBoxes.each(function () {
        this.style.backgroundColor = '#fff';
    });
    emptyTextBoxes.each(function () {
        this.style.backgroundColor = '#f00';
    });
    if ((emptyTextBoxes.length == 0)) {
        adm_HideError(ErrorContainer);
        return true;
    }
    if (ErrorContainer) {
        $(ErrorContainer).html("Należy wypełnić wszystkie wymagane pola.");
        $(ErrorContainer).show();
    }
    else {
        adm_DisplayErrorSimple(null, "Należy wypełnić wszystkie wymagane pola.");
    }
    return false;
}

/* zaznacza wybrane element menu */
function adm_SelectMenuItem(sender) {
    $("ul.adm_menu > li").removeClass('selected');
    if (sender) {
        $(sender).addClass('selected');
    }
}

/* sprawdza czy w odpowiedzi ajaxa jest jakis blad i go wyswietla od razu albo i nie */
function adm_NoError(ajaxResponse, mgr, sender, display, errorContainer) {
    var _errorList = $(ajaxResponse).find('error');
    if ((_errorList) && (_errorList.length > 0)) {
        var _error = mgr.getString(_errorList[0]);
        if (display) {
            if (errorContainer) {
                $(errorContainer).html(_error);
                $(errorContainer).show();
            }
            else {
                adm_DisplayErrorSimple(null, _error);
            }
        }
        adm_SelectMenuItem(sender);
        if (_error.indexOf("niezautoryzowanego") >= 0) {
            $("#adm_menu").hide();
            $("#adm_content").hide();
        }
        return false;
    }
    adm_HideError(errorContainer);
    return true;
}

function adm_HideError(errorContainer) {
    if (errorContainer) {
        $(errorContainer).hide();
    }
    else {
        $("#adm_error").hide();
    }
}

/* wyswietla blad ajaxa */
function adm_DisplayError(errorMessage, sender, display, errorContainer) {
    if (display) {
        if (errorContainer) {
            $(errorContainer).html(errorMessage);
            $(errorContainer).show();
        }
        else {
            adm_DisplayErrorSimple(null, errorMessage);
        }
    }
    adm_SelectMenuItem(sender);
    if (errorMessage.indexOf("niezautoryzowanego") >= 0) {
        $("#adm_menu").hide();
        $("#adm_content").hide();
    }
}

function adm_DisplayErrorSimple(errorField, errorMessage) {
    if (errorField) $(errorField).css('backgroundColor', '#f00');
    $("#adm_error").html(errorMessage);
    $("#adm_error").show();
}
function adm_DisplayErrorDialog(errorMessage) {
    $("#errorMessageP").html(errorMessage);
    $("#errorMessageP").show();
}

/*-------------------------------------------------------
* Zarządzanie instruktorem
-------------------------------------------------------*/
function adm_GameAdministration(sender) {
    adm_HideError(null);
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getGamePanel',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
        },
        OnSuccess: function (content) {
            $("#adm_content").html(content);
            adm_SelectMenuItem(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

function adm_InstructorMainPanel(sender) {
    adm_HideError(null);
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getInstructorMainPanel',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
        },
        OnSuccess: function (content) {
            $("#adm_content").html(content);
            adm_SelectMenuItem(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

/* wyświetla panel z edycją danych instruktora */
function adm_InstructorEditPanel(sender) {
    adm_HideError(null);
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getInstructorEditPanel',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
        },
        OnSuccess: function (content) {
            $("#adm_content").html(content);
            adm_SelectMenuItem(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

/* zapisuje instruktora ale najpierw waliduje pole Email, czy jest już zarejestrowane w systemie i czy należy do niego */
function adm_InstructorEdit(sender) {
    adm_HideError(null);
    if (!validateTextboxes()) {
        return false;
    }
    if (!validateEmailAddress($('#txt_instructorEmail').val())) {
        adm_DisplayErrorSimple($('#txt_instructorEmail'), "Pole Email zawiera niepoprawną wartość.");
        return false;
    }
    if (!checkPhone($('#txt_instructorTel').val())) {
        adm_DisplayErrorSimple($('#txt_instructorTel'), "Pole Telefon zawiera niepoprawną wartość. Można używać jedynie cyfr oraz znaku +, np.: +48 123 456 789");
        return false;
    }
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getInstructorEdit',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("Forename", $("#txt_instructorForename").val());
            xml.Node("Surename", $("#txt_instructorSurename").val());
            xml.Node("Email", $("#txt_instructorEmail").val());
            xml.Node("Title", $("#txt_instructorTitle").val());
            xml.Node("Tel", $("#txt_instructorTel").val());
        },
        OnSuccess: function (content) {
            adm_InstructorMainPanel(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

/* wyświetla panel do zmiany hasła instruktora a następnie po przycisku OK zmienia hasło */
function adm_InstructorChangePasswordPanel(sender) {
    adm_HideError(null);
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getInstructorChangePasswordPanel',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
        },
        OnSuccess: function (content) {
            $("body").append('<div id="instructorCP"></div>');
            $("#instructorCP").html(content);
            $("#instructorCP").dialog({
                title: 'Zmień hasło',
                width: 500,
                height: 'auto',
                modal: true
            });
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        },
        ShowProcessInfo: false
    });
    _mgr.process();
}

/* zamyka panel do zmiany hasła */
function adm_InstructorChangePasswordClose(sender) {
    $("#instructorCP").hide();
    try {
        $("#instructorCP").dialog("destroy");
    }
    catch (e) { }
    $("#instructorCP").remove();
}

/* zmienia hasło instruktora oraz waliduje wprowadzone dane */
function adm_InstructorChangePassword(sender) {
    adm_HideError($("#errorMessageP"));
    var alltextBoxes = $(':password[id^=txt]');
    var emptyTextBoxes = $(':password[value=""][id^=txt][class^=req]');
    alltextBoxes.each(function () {
        this.style.backgroundColor = '#fff';
    });
    emptyTextBoxes.each(function () {
        this.style.backgroundColor = '#f00';
    });
    if ((emptyTextBoxes.length == 0)) {
        $("#errorMessageP").hide();
    }
    else {
        adm_DisplayErrorDialog("Należy wypełnić wszystkie wymagane pola.");
        return false;
    }
    if ($("#txt_instructorPassword").val() != $("#txt_instructorPasswordRe").val()) {
        adm_DisplayErrorDialog("Pole hasło oraz powtórz hasło nie zgadzają się.");
        return false;
    }
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getInstructorChangePassword',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("Password", $("#txt_instructorPassword").val());
            xml.Node("PasswordRe", $("#txt_instructorPasswordRe").val());
        },
        OnSuccess: function (content) {
            adm_InstructorChangePasswordClose(sender);
            alert("Hasło Kadrowca zostało zmienione pomyślnie.");
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true, $("#errorMessageP"));
        }
    });
    _mgr.process();
}

/*------------------------------------------------------
* Zarządzanie klasami z poziomu instruktora
-------------------------------------------------------*/
/* wyświetla panel z listą klas */
function adm_ClassList(sender) {
    adm_HideError(null);
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getClassList',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
        },
        OnSuccess: function (content) {
            $("#adm_content").html(content);
            adm_SelectMenuItem(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

/* wyświetla panel do dodania nowej klasy */
function adm_ClassAddPanel(sender, addParam) {
    adm_HideError(null);
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getClassAddPanel',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("AddParam", addParam);
        },
        OnSuccess: function (content) {
            $("#adm_content").html(content);
            adm_SelectMenuItem(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

/* zapisuje dane nowej klasy */
function adm_ClassAdd(sender) {
    adm_HideError(null);
    if (!validateTextboxes()) {
        return false;
    }
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getClassAdd',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("ClassName", $("#txt_className").val());
        },
        OnSuccess: function (content) {
            adm_ClassList(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

/* wyświetla panel do edycji klasy */
function adm_ClassEditPanel(sender, ClassID) {
    adm_HideError(null);
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getClassEditPanel',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("ClassID", ClassID);
        },
        OnSuccess: function (content) {
            $("#adm_content").html(content);
            adm_SelectMenuItem(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

/* wyświetla panel do edycji klasy */
function adm_ClassEditPanelA(sender, ClassID) {
    adm_HideError(null);
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getClassEditPanelA',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("ClassID", ClassID);
        },
        OnSuccess: function (content) {
            $("#adm_content").html(content);
            adm_SelectMenuItem(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

/* wyświetla panel do edycji klasy */
function adm_ClassEditPanelB(sender, ClassID) {
    adm_HideError(null);
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getClassEditPanelB',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("ClassID", ClassID);
        },
        OnSuccess: function (content) {
            $("#adm_content").html(content);
            adm_SelectMenuItem(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

/* zapisuje dane edytowanej klasy */
/* part=0 = wszystko zapisujemy, part=1 - tylko teaching plan part=2 - tylko oceny */
function adm_ClassEdit(sender, ClassID, part) {
    adm_HideError(null);
    if (!validateTextboxes()) {
        return false;
    }
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getClassEdit',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("ClassName", $("#txt_className").val());
            xml.Node("ClassID", ClassID);
            xml.Node("Part", part);
            if (part = 2 || part == 0) {
                var allComboboxes = $('[id^=cmb]');
                allComboboxes.each(function () {
                    if (this.checked) {
                        xml.Node(this.name, "1");
                    }
                    else {
                        xml.Node(this.name, "0");
                    }
                });
            }
            if (part = 1 || part == 0) {
                var sheetTextBoxes = $(':text[id^=txt][class*=es_class]');
                sheetTextBoxes.each(function () {
                    xml.Node(this.name, this.value);
                });
            }
        },
        OnSuccess: function (content) {
            adm_ClassList(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

/* wyświetla panel do usunięcia klasy */
function adm_ClassRemovePanel(sender, ClassID) {
    adm_HideError(null);
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getClassRemovePanel',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("ClassID", ClassID);
        },
        OnSuccess: function (content) {
            $("#adm_content").html(content);
            adm_SelectMenuItem(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

/* usuwa dane klasy */
function adm_ClassRemove(sender, ClassID) {
    adm_HideError(null);
    if (!validateTextboxes()) {
        return false;
    }
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getClassRemove',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("ClassName", $("#txt_className").val());
            xml.Node("ClassID", ClassID);
        },
        OnSuccess: function (content) {
            $("#adm_content").html(content);
            adm_SelectMenuItem(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

/* wyświetla panel do pokazania statystyki klasy */
function adm_ClassStatsPanel(sender, ClassID) {
    adm_HideError(null);
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getClassStatsPanel',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("ClassID", ClassID);
        },
        OnSuccess: function (content) {
            $("#adm_content").html(content);
            adm_SelectMenuItem(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

/* wyświetla panel do pokazania statystyki klasy - dla wszystkich uczniw zestawienie */
function adm_ClassResultPanel(sender, ClassID) {
    adm_HideError(null);
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getClassResultPanel',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("ClassID", ClassID);
        },
        OnSuccess: function (content) {
            $("#adm_content").html(content);
            adm_SelectMenuItem(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

function adm_ClassCertificate(sender, ClassID) {
    adm_HideError(null);
    if (!confirm("Czy wygenerować certyfikaty dla wszystkich Pracowników w klasie?")) {
        return false;
    }
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getClassCertificate',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("ClassID", ClassID);
        },
        OnSuccess: function (content) {
            alert("Certyfikaty dla wszystkich Pracowników w klasie zostały wygenerowane pomyślnie.");
            adm_ClassList(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

function adm_ClassCertificateRemove(sender, ClassID) {
    adm_HideError(null);
    if (!confirm("Czy usunąć certyfikaty dla wszystkich Pracowników w klasie?")) {
        return false;
    }
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getClassCertificateRemove',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("ClassID", ClassID);
        },
        OnSuccess: function (content) {
            alert("Certyfikaty dla wszystkich Pracowników w klasie zostały usunięte pomyślnie.");
            adm_ClassList(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}
/*-------------------------------------------------------
* Zarządzanie studentami z poziomu instruktora
-------------------------------------------------------*/
/* wyświetla panel z listą studentów */
function adm_StudentList(sender, ClassID) {
    adm_HideError(null);
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getStudentList',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            if (ClassID) xml.Node("ClassID", ClassID);
        },
        OnSuccess: function (content) {
            $("#adm_content").html(content);
            adm_SelectMenuItem(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

/* wyświetla panel do dodania nowej klasy */
function adm_StudentAddPanel(sender, ClassID, AddParam) {
    adm_HideError(null);
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getStudentAddPanel',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("AddParam", AddParam);
            if (ClassID) xml.Node("ClassID", ClassID);
        },
        OnSuccess: function (content) {
            $("#adm_content").html(content);
            adm_SelectMenuItem(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

/* dodaje studenta ale najpierw waliduje pole Email, czy jest już zarejestrowane w systemie */
function adm_StudentAdd(sender, ClassID) {
    adm_HideError(null);
    if (!validateTextboxes()) {
        return false;
    }
    if (!validateEmailAddress($('#txt_studentEmail').val())) {
        $('#txt_studentEmail').css('backgroundColor', '#f00');
        return false;
    }
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getCheckEmail',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("ClassID", ClassID);

            xml.Node("Email", $("#txt_studentEmail").val());
            xml.Node("Forename", $("#txt_studentForename").val());
            xml.Node("Surename", $("#txt_studentSurename").val());
            xml.Node("Email", $("#txt_studentEmail").val());
            xml.Node("IndexNr", $("#txt_studentIndexNr").val());
            xml.Node("Sex", $("#sel_plec").val());
            xml.Node("ExpectedEvaluation", $("#cmb_studentExpectedEvaluation").val());
        },
        OnSuccess: function (content) {
            adm_StudentAddValidated(sender, ClassID);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
            $('#txt_studentEmail').css('backgroundColor', '#f00');
            adm_SelectMenuItem(sender);
        }
    });
    _mgr.process();
}

/* zapisuje dane nowego studenta ale już jak email i inne pola zostały poddane walidacji*/
function adm_StudentAddValidated(sender, ClassID) {
    adm_HideError(null);
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getStudentAdd',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("ClassID", ClassID);

            xml.Node("Forename", $("#txt_studentForename").val());
            xml.Node("Surename", $("#txt_studentSurename").val());
            xml.Node("Email", $("#txt_studentEmail").val());
            xml.Node("IndexNr", $("#txt_studentIndexNr").val());
            xml.Node("Sex", $("#sel_plec").val());
            xml.Node("ExpectedEvaluation", $("#cmb_studentExpectedEvaluation").val());
        },
        OnSuccess: function (content) {
            adm_StudentList(sender, ClassID);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

/* wyświetla panel do edycji danych studenta */
function adm_StudentEditPanel(sender, StudentID) {
    adm_HideError(null);
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getStudentEditPanel',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("StudentID", StudentID);
        },
        OnSuccess: function (content) {
            $("#adm_content").html(content);
            adm_SelectMenuItem(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

/* zapisuje studenta ale najpierw waliduje pole Email, czy jest już zarejestrowane w systemie i czy należy do tego studenta */
function adm_StudentEdit(sender, StudentID, ClassID) {
    adm_HideError(null);
    if (!validateTextboxes()) {
        return false;
    }
    if (!validateEmailAddress($('#txt_studentEmail').val())) {
        $('#txt_studentEmail').css('backgroundColor', '#f00');
        return false;
    }
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getStudentEdit',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("StudentID", StudentID);
            xml.Node("ClassID", ClassID);

            xml.Node("Forename", $("#txt_studentForename").val());
            xml.Node("Surename", $("#txt_studentSurename").val());
            xml.Node("Email", $("#txt_studentEmail").val());
            xml.Node("IndexNr", $("#txt_studentIndexNr").val());
            xml.Node("Sex", $("#sel_plec").val());
            xml.Node("ExpectedEvaluation", $("#cmb_studentExpectedEvaluation").val());
        },
        OnSuccess: function (content) {
            adm_StudentList(sender, ClassID);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

/* wyświetla panel do usunięcia danych studenta */
function adm_StudentRemovePanel(sender, StudentID) {
    adm_HideError(null);
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getStudentRemovePanel',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("StudentID", StudentID);
        },
        OnSuccess: function (content) {
            $("#adm_content").html(content);
            adm_SelectMenuItem(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

/* usuwa studenta */
function adm_StudentRemove(sender, StudentID, ClassID) {
    adm_HideError(null);
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getStudentRemove',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("StudentID", StudentID);
        },
        OnSuccess: function (content) {
            adm_StudentList(sender, ClassID);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

/* wyświetla panel do zmiany hasła studenta a następnie po przycisku OK zmienia hasło */
function adm_StudentChangePasswordPanel(sender, StudentID) {
    adm_HideError(null);
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getStudentChangePasswordPanel',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("StudentID", StudentID);
        },
        OnSuccess: function (content) {
            $("body").append('<div id="studentCP"></div>');
            $("#studentCP").html(content);
            $("#studentCP").dialog({
                title: 'Zmień hasło',
                width: 500,
                height: 'auto',
                modal: true
            });
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        },
        ShowProcessInfo: false
    });
    _mgr.process();
}

/* zamyka panel do zmiany hasła */
function adm_StudentChangePasswordClose(sender, StudentID) {
    $("#studentCP").hide();
    try {
        $("#studentCP").dialog("destroy");
    }
    catch (e) { }
    $("#studentCP").remove();
}

/* zmienia hasło studenta oraz waliduje wprowadzone dane */
function adm_StudentChangePassword(sender, StudentID) {
    adm_HideError($("#errorMessageP"));
    var alltextBoxes = $(':password[id^=txt]');
    var emptyTextBoxes = $(':password[value=""][id^=txt][class^=req]');
    alltextBoxes.each(function () {
        this.style.backgroundColor = '#fff';
    });
    emptyTextBoxes.each(function () {
        this.style.backgroundColor = '#f00';
    });
    if ((emptyTextBoxes.length == 0)) {
        $("#errorMessageP").hide();
    }
    else {
        adm_DisplayErrorDialog("Należy wypełnić wszystkie wymagane pola.");
        return false;
    }
    if ($("#txt_studentPassword").val() != $("#txt_studentPasswordRe").val()) {
        adm_DisplayErrorDialog("Pole hasło oraz powtórz hasło nie zgadzają się.");
        return false;
    }
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getStudentChangePassword',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("StudentID", StudentID);
            xml.Node("Password", $("#txt_studentPassword").val());
            xml.Node("PasswordRe", $("#txt_studentPasswordRe").val());
        },
        OnSuccess: function (content) {
            adm_StudentChangePasswordClose(sender, StudentID);
            alert("Hasło dla Pracownika zostało zmienione poprawnie");
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true, $("#errorMessageP"));
        }
    });
    _mgr.process();
}

/* wyświetla panel do statystyk studenta */
function adm_StudentStatsPanel(sender, StudentID) {
    adm_HideError(null);
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getStudentStatsPanel',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("StudentID", StudentID);
        },
        OnSuccess: function (content) {
            $("#adm_content").html(content);
            adm_SelectMenuItem(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

function adm_StudentClearStats(sender, StudentID) {
    adm_HideError(null);
    if (!confirm("Czy na pewno wyzerować statystykę dla Pracownika?")) {
        return false;
    }
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getStudentClearStats',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("StudentID", StudentID);
        },
        OnSuccess: function (content) {
            $("#adm_content").html(content);
            adm_SelectMenuItem(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

function adm_StudentClearStatsForCourse(sender, TeachingPlanID, StudentID) {
    adm_HideError(null);
    if (!confirm("Czy na pewno wyzerować statystykę wybranego kursu dla Pracownika?")) {
        return false;
    }
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getStudentClearStatsForCourse',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("StudentID", StudentID);
            xml.Node("TeachingPlanID", TeachingPlanID);
        },
        OnSuccess: function (content) {
            $("#adm_content").html(content);
            adm_SelectMenuItem(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

function adm_StudentCertificate(sender, StudentID, ClassID) {
    adm_HideError(null);
    if (!confirm("Czy wygenerować certyfikat dla Pracownika?")) {
        return false;
    }
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getStudentCertificate',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("StudentID", StudentID);
        },
        OnSuccess: function (content) {
            adm_StudentList(sender, ClassID);
            alert("Certyfikat dla pracownika został wygenerowany pomyślnie.");
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

function adm_StudentCertificateRemove(sender, StudentID, ClassID) {
    adm_HideError(null);
    if (!confirm("Czy usunąć wygenerowany certyfikat dla Pracownika?")) {
        return false;
    }
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getStudentCertificateRemove',
        NameSpace: _pizbNameSpace_I,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("StudentID", StudentID);
        },
        OnSuccess: function (content) {
            adm_StudentList(sender, ClassID);
            alert("Certyfikat dla pracownika został usunięty pomyślnie.");
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

/*-------------------------------------------------------
* Zarządzanie studentami z poziomu panelu dla studentów
-------------------------------------------------------*/
/* wyświetla panel główny jaki powinien się uruchamiać po wejściuna stronę adminsitracyjną studenta */
function std_StudentMainPanel(sender, StudentID) {
    adm_HideError(null);
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getStudentMainPanel',
        NameSpace: _pizbNameSpace_S,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("StudentID", StudentID);
        },
        OnSuccess: function (content) {
            $("#adm_content").html(content);
            adm_SelectMenuItem(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

/* wyświetla panel do edycji danych studenta */
function std_StudentEditPanel(sender, StudentID) {
    adm_HideError(null);
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getStudentEditPanel',
        NameSpace: _pizbNameSpace_S,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("StudentID", StudentID);
        },
        OnSuccess: function (content) {
            $("#adm_content").html(content);
            adm_SelectMenuItem(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

/* zapisuje studenta ale najpierw waliduje pole Email, czy jest już zarejestrowane w systemie i czy należy do tego studenta */
function std_StudentEdit(sender, StudentID) {
    adm_HideError(null);
    if (!validateTextboxes()) {
        return false;
    }
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getStudentEdit',
        NameSpace: _pizbNameSpace_S,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("StudentID", StudentID);
            xml.Node("ExpectedEvaluation", $("#cmb_studentExpectedEvaluation").val());
        },
        OnSuccess: function (content) {
            std_StudentMainPanel(sender, StudentID);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

/* wyświetla panel do zmiany hasła studenta a następnie po przycisku OK zmienia hasło */
function std_StudentChangePasswordPanel(sender, StudentID) {
    adm_HideError(null);
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getStudentChangePasswordPanel',
        NameSpace: _pizbNameSpace_S,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("StudentID", StudentID);
        },
        OnSuccess: function (content) {
            $("body").append('<div id="studentCP"></div>');
            $("#studentCP").html(content);
            $("#studentCP").dialog({
                title: 'Zmień hasło',
                width: 500,
                height: 'auto',
                modal: true
            });
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

/* zamyka panel do zmiany hasła */
function std_StudentChangePasswordClose(sender, StudentID) {
    $("#studentCP").hide();
    try {
        $("#studentCP").dialog("destroy");
    }
    catch (e) { }
    $("#studentCP").remove();
}

/* zmienia hasło studenta oraz waliduje wprowadzone dane */
function std_StudentChangePassword(sender, StudentID) {
    adm_HideError($("#errorMessageP"));
    var alltextBoxes = $(':password[id^=txt]');
    var emptyTextBoxes = $(':password[value=""][id^=txt][class^=req]');
    alltextBoxes.each(function () {
        this.style.backgroundColor = '#fff';
    });
    emptyTextBoxes.each(function () {
        this.style.backgroundColor = '#f00';
    });
    if ((emptyTextBoxes.length == 0)) {
        $("#errorMessageP").hide();
    }
    else {
        adm_DisplayErrorDialog("Należy wypełnić wszystkie wymagane pola.");
        return false;
    }
    if ($("#txt_studentPassword").val() != $("#txt_studentPasswordRe").val()) {
        adm_DisplayErrorDialog("Pole hasło oraz powtórz hasło nie zgadzają się.");
        return false;
    }
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getStudentChangePassword',
        NameSpace: _pizbNameSpace_S,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("StudentID", StudentID);
            xml.Node("Password", $("#txt_studentPassword").val());
            xml.Node("PasswordRe", $("#txt_studentPasswordRe").val());
        },
        OnSuccess: function (content) {
            std_StudentChangePasswordClose(sender, StudentID);
            alert("Hasło dla Pracownika zostało zmienione poprawnie");
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true, $("#errorMessageP"));
        }
    });
    _mgr.process();
}

/* wyświetla panel do statystyk studenta */
function std_StudentStatsPanel(sender, StudentID) {
    adm_HideError(null);
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getStudentStatsPanel',
        NameSpace: _pizbNameSpace_S,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("StudentID", StudentID);
        },
        OnSuccess: function (content) {
            $("#adm_content").html(content);
            adm_SelectMenuItem(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

/* wyświetla panel do pokazania statystyki klasy - dla wszystkich uczniow zestawienie */
function std_getClassResultPanelStudent(sender, StudentID, ClassID) {
    adm_HideError(null);
    var _mgr = new GAjaxManager({
        BID: $("#BID").val(),
        Function: 'getClassResultPanelStudent',
        NameSpace: _pizbNameSpace_S,
        FormatParams: function (xml) {
            xml.Node("BID", $("#BID").val());
            xml.Node("InstructorID", $("#InstructorID").val());
            xml.Node("ClassID", ClassID);
            xml.Node("StudentID", StudentID);
        },
        OnSuccess: function (content) {
            $("#adm_content").html(content);
            adm_SelectMenuItem(sender);
        },
        OnError: function (errorMessage) {
            adm_DisplayError(errorMessage, sender, true);
        }
    });
    _mgr.process();
}

function setSliders(groupName, min, max) {
    $('div[id ^= slider][rel="' + groupName + '"]').slider({
        range: true,
        min: min,
        max: max,
        slide: function (event, ui) {
            //wybrana wartosc musi sie roznic co najmniej o 1
            if (ui.values[1] - ui.values[0] < 1) return false;
            var slidersGroup = $('.ui-slider[rel="' + groupName + '"]');
            //pozycja aktualnie zmienianego slidera
            var position = slidersGroup.index($(event.target));
            //blokada min dla pierwszego slidera
            if (position == 0 && ui.values[0] > min) return false;
            //aktualizacja poprzedniego slidera - jesli nie jest to pierwszy slider
            if (position > 0) {
                var prevSlider = $(slidersGroup.get(position - 1));
                //jesli min wartosc aktualnie wybranego nie jest nizsza niz min poprzedniego+1
                if (ui.values[0] > (prevSlider.slider("values", 0) + 1))
                    prevSlider.slider("values", 1, ui.values[0] - 1);
                else return false;
            }
            //aktualizacja kolejnego slidera - jesli nie jest to ostatni slider
            if (position < slidersGroup.length - 1) {
                var nextSlider = $(slidersGroup.get(position + 1));
                //jesli max wartosc wybrana aktualnie nie przekracza max nastepnego-1
                if (ui.values[1] < (nextSlider.slider("values", 1) - 1))
                    nextSlider.slider("values", 0, ui.values[1] + 1);
                else return false;
            }
            //blokada max dla ostatniego slidera
            if (position == (slidersGroup.length - 1) && ui.values[1] < max) return false;
            var postfix = $(event.target).attr("id").substring(7);
            $("#txt_from_" + postfix).val(ui.values[0]);
            $("#txt_to_" + postfix).val(ui.values[1]);
        }
    });
    $('.ui-slider[rel="' + groupName + '"]').each(function () {
        var postfix = $(this).attr("id").substring(7);
        $(this).slider("values", 0, $("#txt_from_" + postfix).val());
        $(this).slider("values", 1, $("#txt_to_" + postfix).val());
    });
    $('.ui-slider[rel="' + groupName + '"]').bind("slidechange", function (event, ui) {
        var postfix = $(event.target).attr("id").substring(7);
        $("#txt_from_" + postfix).val(ui.values[0]);
        $("#txt_to_" + postfix).val(ui.values[1]);
    });
    $('.ui-slider:first[rel="' + groupName + '"]').slider("values", 0, min);
    $('.ui-slider:last[rel="' + groupName + '"]').slider("values", 1, max);
}

function initMenu(pageType) {
    if (pageType != 0) {
        return;
    }
    $('#floatingmenu').show();
}